package C4LJ;

use C4LJ::Article;
use strict;
use warnings;

our $VERSION = '0.003';
sub version { return $VERSION }

=head1 NAME 

C4LJ - a read-only API against the Code4Lib Journal (WordPress) database


=head1 SYNOPSIS

  use C4LJ::Article;
  foreach ( C4LJ::Article->get_articles ) {
    print '        ID: ' . $_->id       . "\n";
    print '     Title: ' . $_->title    . "\n";
    print '       URL: ' . $_->url      . "\n";
    print '  Abstract: ' . $_->abstract . "\n";
    print '    Author: ' . $_->author   . "\n";
    print '      Date: ' . $_->date     . "\n";
    print '     Issue: ' . $_->issue    . "\n";
    print "\n";
  }


=head1 DESCRIPTION

Code4Lib Journal is the refereed serial of the Code4Lib community. [1] The community desires to make the Journal's content as widely accessible as possible. To that end, this Perl module is a read-only API against the Journal's underlying WordPress database. Its primary purpose is to generate XML files that can be uploaded to the Directory of Open Access Journals and consequently made available through their OAI interface. [2]

[1] http://journal.code4lib.org/

[2] http://www.doaj.org/doaj?func=loadTempl&templ=070509

=head1 AUTHOR

Eric Lease Morgan <emorgan@nd.edu>

=cut

1;
