import java.io.*;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.*;
import org.apache.lucene.index.*;
import org.marc4j.*;
import org.marc4j.marc.*;

public class Index {

	static final File INDEX_DIR = new File( "index" );

	public static void main( String[] args ) throws Exception {
	
		InputStream in     = new FileInputStream( "catalog-new.marc" );
		MarcReader reader  = new MarcStreamReader( in );
		IndexWriter writer = new IndexWriter( INDEX_DIR, new StandardAnalyzer(), true );
		int i = 1;
		while ( reader.hasNext() ) {
		
			// initialize
			Record record     = reader.next();
			String title      = "";
			String author     = "";
			String callnumber = "";
			String fulltext   = "";
			
			// get the author
			try {
			
				DataField author_field   = ( DataField ) record.getVariableField( "100" );
				Subfield author_subfield = author_field.getSubfield( 'a' );
				author            = author_subfield.getData();
				
			}
			catch (NullPointerException npe) { ; }

			// get the title
			try {
			
				DataField title_field   = ( DataField ) record.getVariableField( "245" );
    			Subfield title_subfield = title_field.getSubfield( 'a' );
				title                   = title_subfield.getData();
				
			}
			catch (NullPointerException npe) { ; }
			
			// call number
			try {
			
				DataField callnumber_field   = ( DataField ) record.getVariableField( "050" );
				Subfield callnumber_subfield = callnumber_field.getSubfield( 'a' );
				callnumber                   = callnumber_subfield.getData();

			}
			catch (NullPointerException npe) { ; }
			
			// echo
			System.out.println( "       Record: " + i );
			System.out.println( "       Author: " + author );
			System.out.println( "        Title: " + title );
			System.out.println( "  Call number: " + callnumber );
			System.out.println( "" );
			
			// define full text
			fulltext = title + " " + author;
			
			// add it to the index
			Document doc = new Document();
			doc.add( new Field( "title",      title,      Field.Store.YES, Field.Index.TOKENIZED ));
			doc.add( new Field( "author",     author,     Field.Store.YES, Field.Index.TOKENIZED ));
			doc.add( new Field( "callnumber", callnumber, Field.Store.YES, Field.Index.TOKENIZED ));
			doc.add( new Field( "fulltext",   fulltext,   Field.Store.YES, Field.Index.TOKENIZED ));
			writer.addDocument( doc );
			
			// exit after n records
			i++; 
			//if ( i > 100000 ) { break; }
			
		}

		// clean up and done
		System.out.println( "Optimizing..." );
		writer.optimize();
		writer.close();

	}

}
