<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- plain o' text -->
	<xsl:output method='text'/>
	
	<!-- let's get started -->
	<xsl:template match="/letter">

		<!-- date -->
		<xsl:text>&#xa;</xsl:text>	
		<xsl:value-of select='normalize-space(date)'/>
		<xsl:text>&#xa;&#xa;</xsl:text>	
		
		<!-- address -->
		<xsl:value-of select='normalize-space(addressee/name)'/>
		<xsl:text>&#xa;</xsl:text>
		<xsl:value-of select='normalize-space(addressee/address_one)'/>
		<xsl:text>&#xa;</xsl:text>
		<xsl:value-of select='normalize-space(addressee/address_two)'/>
		<xsl:text>&#xa;&#xa;</xsl:text>
		
		<!-- greeting -->
		<xsl:value-of select='normalize-space(greeting)'/>
		<xsl:text>&#xa;&#xa;</xsl:text>	
		
		<!-- paragraphs -->
		<xsl:for-each select='paragraph'>
			<xsl:value-of select='normalize-space(.)'/>
			<xsl:text>&#xa;&#xa;</xsl:text>	
		</xsl:for-each>
		
		<!-- closing -->
		<xsl:value-of select='normalize-space(closing)'/>
		<xsl:text>&#xa;&#xa;</xsl:text>	
	
	</xsl:template>
	
</xsl:stylesheet>
