<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- create valid XHTML declaration -->
	<xsl:output 
	  method='xml'
	  omit-xml-declaration='no'
	  indent='yes'
	  doctype-public='-//W3C//DTD XHTML 1.0 Transitional//EN' 
	  doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd' />
	
	<!-- try to make things pretty -->
	<xsl:strip-space elements='*'/>

	<!-- let's get started -->
	<xsl:template match="/letter">

		<html>
		
			<head>
				<title><xsl:value-of select='normalize-space(addressee/name)'/></title>
			</head>
			
			<body style='margin: 5%'>
			
				<!-- do the work -->
				<xsl:apply-templates/>
				
			</body>
		
		</html>
							
	</xsl:template>
	
	
	<!-- trap all the various elements -->
	
	<xsl:template match='date | greeting'>
		<p><xsl:value-of select='normalize-space(.)'/></p>
	</xsl:template>

	<xsl:template match='addressee'>
		<p><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match='addressee'>
		<p><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match='paragraph'>
		<p style='text-indent:1em'><xsl:apply-templates/></p>
	</xsl:template>
	

	<xsl:template match='name | address_one'>
		<xsl:value-of select='normalize-space(.)'/>
		<br />	
	</xsl:template>
	

	<xsl:template match='list'>
		<ul><xsl:apply-templates/></ul>
	</xsl:template>
	
	
	<xsl:template match='italics'>
		<em><xsl:apply-templates/></em>
	</xsl:template>
	
	
	<xsl:template match='item'>
		<li><xsl:apply-templates/></li>
	</xsl:template>
	
	
	<xsl:template match='closing'>
		<p style='text-align:right'><xsl:value-of select='normalize-space(.)'/></p>
	</xsl:template>
	
</xsl:stylesheet>
