<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	
	<xsl:output 
		method="xml"
		omit-xml-declaration="no"
		indent="yes"
		doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
		doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />
			
	<!-- letter -->
	<xsl:template match="letter">
		<html>
		<head>
				<title><xsl:value-of select="addressee/name"/></title>
			</head>
			<body style="margin: 5%">
				<xsl:apply-templates select="date"/>
				<xsl:apply-templates select="addressee"/>
				<xsl:apply-templates select="greeting"/>
				<xsl:apply-templates select="paragraph | list"/>
				<xsl:apply-templates select="closing"/>
			</body>
		</html>
	</xsl:template>
	
	<!-- date -->
	<xsl:template match="date">
		<p><xsl:value-of select="."/></p>
	</xsl:template>
	 
	<!-- addressee -->
	<xsl:template match="addressee">
		<p>
			<xsl:value-of select="name"/><br />
			<xsl:value-of select="address_one"/><br />
			<xsl:value-of select="address_two"/>
		</p>
	</xsl:template>
	 
	<!-- greeting -->
	<xsl:template match="greeting">
		<p><xsl:value-of select="."/></p>
	</xsl:template>
		
	<!-- paragraph -->
	<xsl:template match="paragraph">
		<p style="text-indent: 1em"><xsl:apply-templates/></p>
	</xsl:template>

	<!-- closing -->
	<xsl:template match="closing">
		<p style="margin-top: 3em; text-align: right"><xsl:value-of select="."/></p>
	</xsl:template>
	
	<!-- italics -->
	<xsl:template match='italics'>
   		<i><xsl:value-of select='.'/></i>
	</xsl:template>
		
	<!-- list -->
	<xsl:template match='list'>
   		<ul><xsl:apply-templates/></ul>
	</xsl:template>
		
	<!-- item -->
	<xsl:template match='item'>
   		<li><xsl:apply-templates/></li>
	</xsl:template>
		
</xsl:stylesheet>