# marc-write.pl - a Perl script to write a simple MARC record to a file

# Eric Lease Morgan (emorgan@nd.edu)
# September 1, 2003 - Labor Day

# based on Example #9 of the MARC::Doc::Tutoral

# use the necessary module
use MARC::Record;

# create a new MARC record object
my $record = MARC::Record->new();

# add a generic leader to the object
$record->leader('00903pam  2200265 a 4500');

# get an author's name
print "What is the author's name? ";
chop (my $author = <STDIN>);
$author = MARC::Field->new('100', '1', '', a => $author);

# get a title
print "What is the title? ";
chop (my $title = <STDIN>);
$title = MARC::Field->new('245', '1', '0', a => "$title");

# append the input to the object
$record->append_fields($author, $title);

# get subjects
do {

	# get a subject
	print "Enter a subject. (Press return when finished.) ";
	chop ($s = <STDIN>);
	
	# make sure it exists
	if ($s) {
	
		# add it to the object
		$subject = MARC::Field->new('650', '1', '', a => $s);
		$record->append_fields($subject);
		 
	}
	
} until ! $s;

# get the name of an output file
print "To what file should this data be appended? ";
chop (my $output = <STDIN>);

# open, write to, and close the output file 
open (OUTPUT, ">> $output");
print OUTPUT $record->as_usmarc();
close (OUTPUT);

# done
exit;
