<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:mods="http://www.loc.gov/mods/v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!--

	mod2sql.xsl - transform mods into sql; a brain-dead database application
	
	Eric Lease Morgan <eric_morgan@infomotions.com>
	May 31, 2004 - getting ready for Shining a LAMP on XML 'n Monterey

-->

	<!-- plain o' text -->
	<xsl:output method='text'/>
	
	<!-- let's get started -->
	<xsl:template match="/mods:modsCollection">

		<!-- create the items table -->
		<xsl:text># this is a very simple (brain-dead) library catalog "application"&#xa;&#xa;</xsl:text>
		<xsl:text># create an items table&#xa;</xsl:text>
		<xsl:text>DROP TABLE IF EXISTS items;&#xa;</xsl:text>
		<xsl:text>CREATE TABLE items (&#xa; id INT(3) NOT NULL AUTO_INCREMENT,&#xa; creator VARCHAR(255) NOT NULL default '',&#xa; title VARCHAR(255) NOT NULL default '',&#xa; sort_title VARCHAR(255) NOT NULL default '',&#xa; subjects VARCHAR(255) NOT NULL default '',&#xa; publisher VARCHAR(255) NOT NULL default '',&#xa; date VARCHAR(255) NOT NULL default '',&#xa; call_number VARCHAR(255) NOT NULL default '',&#xa; extent VARCHAR(255) NOT NULL default '',&#xa; notes VARCHAR(255) NOT NULL default '',&#xa; responsibility VARCHAR(255) NOT NULL default '',&#xa; PRIMARY KEY (id)&#xa;);&#xa;&#xa;</xsl:text>

		<!-- create sets of INSERT statements -->
		<xsl:text># insert bunches o' data&#xa;</xsl:text>
		<xsl:for-each select='mods:mods'>
			
			<!-- initialize the statement -->
			<xsl:text>INSERT INTO items (creator, title, sort_title, subjects, publisher, date, call_number, extent, notes, responsibility) VALUES ('</xsl:text>
			
			<!-- author (creator) -->
			<xsl:for-each select='mods:name'>
				<xsl:choose>
					<xsl:when test='mods:role/mods:roleTerm = "creator"'>
						<xsl:call-template name='delete_apostrophe'>
							<xsl:with-param name='s'  select='mods:namePart'/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name='delete_apostrophe'>
							<xsl:with-param name='s' select='mods:namePart'/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text> </xsl:text>
			</xsl:for-each>
			<xsl:text>', '</xsl:text>
			
			<!-- title -->
			<xsl:choose>
				
				<!-- look for non sorting words -->
				<xsl:when test='mods:titleInfo/mods:nonSort'>
					<xsl:value-of select='mods:titleInfo/mods:nonSort'/>
					<xsl:call-template name='delete_apostrophe'>
						<xsl:with-param name='s' select='mods:titleInfo/mods:title'/>
					</xsl:call-template>
				</xsl:when>
				
				<!-- none found; output just the title -->
				<xsl:otherwise>
					<xsl:call-template name='delete_apostrophe'>
						<xsl:with-param name='s' select='mods:titleInfo/mods:title'/>
					</xsl:call-template>
				</xsl:otherwise>
				
			</xsl:choose>
			<xsl:text>', '</xsl:text>
			
			<!-- sort title -->
			<xsl:call-template name='delete_apostrophe'>
				<xsl:with-param name='s' select='mods:titleInfo/mods:title'/>
			</xsl:call-template>
			<xsl:text>', '</xsl:text>

			<!-- subjects -->
			<xsl:for-each select='mods:subject/mods:topic'>
				<xsl:call-template name='delete_apostrophe'>
					<xsl:with-param name='s'  select='.'/>
				</xsl:call-template>
				<xsl:text>; </xsl:text>
			</xsl:for-each>
			<xsl:text>', '</xsl:text>
			
			<!-- publisher -->
			<xsl:call-template name='delete_apostrophe'>
				<xsl:with-param name='s'  select='mods:originInfo/mods:publisher'/>
			</xsl:call-template>
			<xsl:text>', '</xsl:text>

			<!-- date -->
			<xsl:value-of select='mods:originInfo/mods:dateIssued'/>
			<xsl:text>', '</xsl:text>

			<!-- lc call number -->
			<xsl:value-of select='mods:classification[@authority="lcc"]'/>
			<xsl:text>', '</xsl:text>

			<!-- physical description (extent) -->
			<xsl:call-template name='delete_apostrophe'>
				<xsl:with-param name='s' select='mods:physicalDescription/mods:extent'/>
			</xsl:call-template>
			<xsl:text>', '</xsl:text>

			<!-- notes -->
			<xsl:for-each select='mods:note'>
				<xsl:call-template name='delete_apostrophe'>
					<xsl:with-param name='s' select='.'/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
			</xsl:for-each>
			<xsl:text>', '</xsl:text>
			
			<!-- statement of resposibility -->
			<xsl:call-template name='delete_apostrophe'>
				<xsl:with-param name='s' select='mods:note[@type="statement of responsibility"]'/>
			</xsl:call-template>
			<xsl:text>'</xsl:text>
			
			<!-- clean up -->
			<xsl:text>);&#xa;</xsl:text>
			
		</xsl:for-each>
	</xsl:template>
	
	<!-- a really poor excuse for a find/replace routine -->
	<xsl:template name='delete_apostrophe'>
		<xsl:param name='s'/>
		<xsl:variable name='a'>&apos;</xsl:variable>
		<xsl:choose>
			<xsl:when test='contains($s, $a)'>
			<xsl:value-of select="translate($s, $a, '')"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select='$s'/>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
